package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.datalayer.CustomTextFormRepository;
import gov.va.vamf.scheduling.varutility.domain.CustomFriendlyText;
import gov.va.vamf.scheduling.varutility.domain.CustomFriendlyTexts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomTextFormService {
    @Autowired
    private CustomTextFormRepository customTextFormRepository;

    public CustomFriendlyText fetchCustomFriendlyTextBySiteCode(String siteCode) {
        return customTextFormRepository.findBySiteCode(siteCode);
    }

    public CustomFriendlyText saveCustomFriendlyText(CustomFriendlyText customFriendlyText) {
        return customTextFormRepository.save(customFriendlyText);
    }

    public CustomFriendlyTexts deleteCustomFriendlyTextBySiteCode(String siteCode) {
        return customTextFormRepository.deleteBySiteCode(siteCode);
    }

}
